VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsUser"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'-----------------------------------------------------
' MirageBot User Object
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

Private v_Username As String, v_Flags As Long, v_Statstring As String

Public Ping As Double, _
       Client As String, _
       Expansion As Boolean, _
       Character As String, _
       Account As String, _
       LastMessage As String

Public TickJoin As Double, _
       TickTalk As Double, _
       TickWhisper As Double, _
       TickEmote As Double, _
       TickLeave As Double

Public IsRepresentative As Boolean, _
       IsOperator As Boolean, _
       IsSpeaker As Boolean, _
       IsAdministrator As Boolean, _
       IsPlug As Boolean, _
       IsIgnored As Boolean, _
       IsCharacter As Boolean, _
       IsBannable As Boolean, _
       IsInvisible As Boolean, _
       IsShown As Boolean, _
       IsSilenced As Boolean, _
       IsBeingRemoved As Boolean

Public Property Let Username(Value As String)
    v_Username = Value
    Account = Suffix(Value)
    Character = Prefix(Value)
    IsCharacter = (InStr(Value, "*") <> 0)
End Property

Public Property Get Username() As String
    Username = v_Username
End Property

Public Property Let Flags(Value As Long)
    v_Flags = Value
    IsRepresentative = (Value And &H1)
    IsOperator = (Value And &H2)
    IsSpeaker = (Value And &H4)
    IsAdministrator = (Value And &H8)
    IsPlug = (Value And &H10)
    IsIgnored = (Value And &H20)
    IsBannable = Not (IsOperator Or IsAdministrator Or IsRepresentative Or IsSpeaker)
End Property

Public Property Get Flags() As Long
    Flags = v_Flags
End Property

Public Property Let Statstring(Value As String)
    v_Statstring = Value
    Client = StrReverse$(Left$(Value, 4))
    Expansion = (Value = "D2XP" Or Value = "W3XP")
End Property

Public Property Get Statstring() As String
    Statstring = v_Statstring
End Property

Public Property Get IsIdle() As Boolean
    IsIdle = False
    If (TickTalk > 0) Then
        If ((DblTickCount - TickTalk) >= 300000) Then IsIdle = True
    Else
        If ((DblTickCount - TickJoin) >= 300000) Then IsIdle = True
    End If
End Property

Public Property Get IsIdler() As Boolean
    IsIdler = False '18000000
    If (TickTalk > 0) Then
        If ((DblTickCount - TickTalk) >= 600000) Then IsIdler = True
    Else
        If ((DblTickCount - TickJoin) >= 600000) Then IsIdler = True
    End If
End Property

Public Property Get IsIdlest() As Boolean
    IsIdlest = False '27000000
    If (TickTalk > 0) Then
        If ((DblTickCount - TickTalk) >= 900000) Then IsIdlest = True
    Else
        If ((DblTickCount - TickJoin) >= 900000) Then IsIdlest = True
    End If
End Property

